@extends('layouts.app')

@section('title', 'My Tickets')

@section('content')
<div class="tickets-page">
    <div class="container">
        <h1>My Tickets</h1>
        
        <div class="tickets-header">
            <a href="{{ route('tickets.create') }}" class="btn btn-primary">Create New Ticket</a>
        </div>

        @if($tickets->count() > 0)
            <div class="tickets-list">
                @foreach($tickets as $ticket)
                    <div class="ticket-card">
                        <div class="ticket-header">
                            <h3><a href="{{ route('tickets.show', $ticket) }}">{{ $ticket->subject }}</a></h3>
                            <span class="badge badge-{{ $ticket->status }}">{{ ucfirst($ticket->status) }}</span>
                        </div>
                        <p class="ticket-description">{{ Str::limit($ticket->description, 150) }}</p>
                        <div class="ticket-meta">
                            <span>Priority: {{ ucfirst($ticket->priority) }}</span>
                            <span>Created: {{ $ticket->created_at->format('M d, Y H:i') }}</span>
                            @if($ticket->replies->count() > 0)
                                <span>{{ $ticket->replies->count() }} {{ Str::plural('reply', $ticket->replies->count()) }}</span>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <p>You don't have any tickets yet. <a href="{{ route('tickets.create') }}">Create your first ticket</a></p>
        @endif
    </div>
</div>
@endsection

